
/*
 * Primeiro exerccio do Tutorial de J2ME
 *
 * @author Tarcisio Camara
 */

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.CommandListener;

/**
 * Possui o looping do jogo implementado numa Thread separada.
 *  responsvel por controles alto nvel do jogo como tratamento
 * de softkey e estado do jogo (pause/resume/game over)
 */
public class ShipController implements Runnable, CommandListener {
    
    /** Indica se o jogo esta pausado */
    private static boolean isPaused = false;

    /** Indica se o jogo acabou */
    private static boolean gameOver = false;

    /** Tela principal do jogo */
    private ShipGameScreen gameScreen;

    /**
     * Constructor
     * param s Tela principal do jogo
     */
    public ShipController(ShipGameScreen s) {
        this.gameScreen = s;

    }

    /**
     * Looping principal do jogo
     */
    public void run() {
        while(!gameOver) {
            if(!isPaused) {
                // atualiza os objetos do jogo
                this.gameScreen.update();

                // chama o mtodo para pintar objetos
                this.gameScreen.repaint();
                this.gameScreen.serviceRepaints();

                // Dorme um pouco pra dar tempo de processar eventos
                try {
                    Thread.sleep(30);
                } catch(Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * Inicializa a thread do looping
     */
    public void init(){
           Thread t = new Thread(this);
           t.start();
    }

    /**
     * Processa o pressionamento das soft keys
     * @param c, Commando pressionado
     * @param d, Tela que originou o pressionamento
     */
    public void commandAction(Command c, Displayable d) {
        //Comando EXIT pressionado
        if(c==Constants.exitCommand){
             ShipMidlet.getInstance().destroyApp(true);

        //Comando PAUSE pressionado
        }if(c==Constants.pauseCommand){
             setPaused(true);
             //troca os comandos pause por resume
             gameScreen.removeCommand(Constants.pauseCommand);
             gameScreen.addCommand(Constants.resumeCommand);

        //Comando RESUME pressionado
        }if(c==Constants.resumeCommand){
             setPaused(false);
             //troca os comandos resume por pause
             gameScreen.addCommand(Constants.pauseCommand);
             gameScreen.removeCommand(Constants.resumeCommand);
        }
    }

    
    /* ************************************************************/
    /* Mtodos get() e set()
    /* ************************************************************/
    
    public static boolean isPaused() {
        return isPaused;
    }

    public static void setPaused(boolean paused) {
        isPaused = paused;
    }

    public boolean isGameOver() {
        return gameOver;
    }

    public static void setGameOver(boolean isGameOver) {
        gameOver = isGameOver;
    }    
}
